unit TheStatusBar;
{*****************************************************************}
{                                                                 }
{ Enhanced freeware StatusBar component                           }
{ By Kevin S. Gallagher                                           }
{                                                                 }
{ The main goal of this component was to allow it to decide if a  }
{ SizeGrip is needed. If the form this component is placed onto   }
{ is sizeable it will have a SizeGrip, otherwise no SizeGrip.     }
{                                                                 }
{ I seem to be adding another panel for either an explorer style  }
{ button or a progressbar a lot, hence two panels are added. The  }
{ first panels width equals zero making it invisible. The second  }
{ panel is setup for showing application hints.                   }
{                                                                 }
{ abnormalities                                                   }
{ After placing the StatusBar on a non-sizable form then changing }
{ it to sizable, the grip will not go away. It  still works       }
{ correctly at runtime as expected.                               }
{=================================================================}
{ USE TSmartStatusBar AT YOUR OWN RISK.                           }
{ I AM NOT RESPONSIBLE FOR ANY HARM THIS COMPONENT MIGHT CAUSE!!  }
{                                                                 }
{ Kevin S. Gallagher                                              }
{ E-Mail : Gallaghe@teleport.com                                  }
{                                                                 }
{*****************************************************************}

{$IFNDEF WIN32}
  ERROR!  This unit only available for 32bit Delphi!!!
{$ENDIF}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, DsgnIntf;

type
  TAbout = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

  TSmartStatusBar = class(TStatusBar)
  private
    FOnResize: TNotifyEvent;
    FSizeGrip: Boolean;
    FAbout: TAbout;
    FForm: TForm;
    FOldOnHint: TNotifyEvent;
    FSysOnHint: TNotifyEvent;
    FShowAppHint: boolean;
    procedure SetShowAppHint(b : boolean);
    procedure SetUpSizeGrip;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure DispAppHint(Sender : TObject);
  public
    constructor Create(AOwner: TComponent); override;
  published
    property About: TAbout read FAbout write FAbout;
    property ShowAppHint : boolean read FShowAppHint write SetShowAppHint default True;
  end;

procedure Register;

implementation

uses Commctrl;

procedure TAbout.Edit;
begin
  Application.MessageBox('TSmartStatusBar component'  + #13 +
  ' 1998 Kevin S. Gallagher - This component is freeware.',
  'About TSmartStatusBar Component', MB_OK + MB_ICONINFORMATION);
end;

function TAbout.GetAttributes: TPropertyAttributes;
begin
  Result:= [paMultiSelect, paDialog, paReadOnly];
end;

function TAbout.GetValue: string;
begin
  Result:= '(about)';
end;

constructor TSmartStatusBar.Create(AOwner: TComponent);
begin
  if not(AOwner is TForm) then
    raise EInvalidOperation.Create('Can only drop me on a form');

  inherited Create(AOwner);

  FSizeGrip := True;
  FShowAppHint := True;
  ShowAppHint := True;
  FSysOnHint := Application.OnHint;

  ControlStyle := ControlStyle + [csAcceptsControls];

  FForm := TForm(AOwner);

  Panels.add;
  Panels.Items[0].Text := '';
  Panels.Items[0].Width := 0;
  Panels.Items[0].Style := psText;
  Panels.Items[0].Bevel := pbLowered;
  Panels.Items[0].Alignment := taLeftJustify;
  Panels.add;
  Panels.Items[1].Text := '';
  Panels.Items[1].Width := FForm.ClientWidth; // GetParentForm(self).ClientWidth;
  Panels.Items[1].Style := psText;
  Panels.Items[1].Bevel := pbLowered;
  Panels.Items[1].Alignment := taLeftJustify;

  SetUpSizeGrip;
end;

procedure TSmartStatusBar.SetUpSizeGrip;
begin
  if FForm <> nil then
    with FForm do
      FSizeGrip :=  not(BorderStyle in [bsToolWindow,bsDialog,bsNone,bsSingle]);
  SizeGrip := FSizeGrip;
end;

procedure TSmartStatusBar.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  CreateSubClass(Params, STATUSCLASSNAME);

  with Params do begin
    SetUpSizeGrip;
    if FSizeGrip then
      Style := Style or SBARS_SIZEGRIP
    else
      Style := Style or CCS_TOP;
    WindowClass.style := WindowClass.style and not CS_HREDRAW;
  end;
end;

procedure TSmartStatusBar.SetShowAppHint(b : boolean) ;
begin
  FShowAppHint := b ;
  if not(csDesigning in ComponentState) then begin
    if b then begin
      FOldOnHint := Application.OnHint ;
      Application.OnHint := DispAppHint ;
    end else
      Application.OnHint := FOldOnHint ;
  end;
end;

procedure TSmartStatusBar.DispAppHint(Sender : TObject) ;
begin
  if not(csDesigning in ComponentState) then
    if FShowAppHint then
    Panels[1].Text := Application.Hint ;
  if Assigned(FOldOnHint) then
    FOldOnHint(Sender) ;
end;

procedure Register;
begin
  RegisterComponents('Win32', [TSmartStatusBar]);
  RegisterPropertyEditor(TypeInfo(TAbout), TSmartStatusBar, 'ABOUT', TAbout);
end;
end.
